% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myTarGetInAppStats.R
\name{myTarGetInAppStats}
\alias{myTarGetInAppStats}
\title{Returns statistics on mobile app events attributed with advertising impressions myTarget by campaigns and banners}
\usage{
myTarGetInAppStats(
  date_from = Sys.Date() - 7,
  date_to = Sys.Date(),
  object_type = "campaigns",
  object_id = NULL,
  attribution = c("conversion", "impression"),
  conversion_type = c("postview", "postclick", "total"),
  auth = NULL,
  login = getOption("rmytarget.login"),
  token_path = myTarTokenPath()
)
}
\arguments{
\item{date_from}{Start date}

\item{date_to}{End date}

\item{object_type}{API object type, character value, apply one of campaigns, banners, users}

\item{object_id}{ID of API object (id campaign or any object)}

\item{attribution}{Attributing by event time or impression time. Available options: conversion, impression}

\item{conversion_type}{Conversion type: postclick - postclick, postview - postview, total - total.}

\item{auth}{R auth object}

\item{login}{Your login, or client name in MyTarget account}

\item{token_path}{Path to directory where you save credential data}
}
\value{
tibble with fast statistics
}
\description{
Returns statistics on mobile app events attributed with advertising impressions myTarget by campaigns and banners
}
\examples{
\dontrun{
rt_stat <- myTarGetFastStats()
}
}
