% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RrT.r
\name{RrT.aad}
\alias{RrT.aad}
\title{Robust estimator for a generalized ratio model
with Tukey biweight function and AAD scale
by iteratively re-weighted least squares (IRLS) algorithm for M-estimation}
\usage{
RrT.aad(x1, y1, g1 = 0.5, c1 = 8, rp.max = 100, cg.rt = 0.01)
}
\arguments{
\item{x1}{single explanatory variable}

\item{y1}{objective variable}

\item{g1}{power (default: g1=0.5(conventional ratio model))}

\item{c1}{tuning parameter usually from 4 to 8 (smaller figure is more robust)}

\item{rp.max}{maximum number of iteration}

\item{cg.rt}{convergence condition to stop iteration (default: cg1=0.001)}
}
\value{
a list with the following elements
\item{\code{par}}{robustly estimated ratio of \code{y1} to \code{x1}}
\item{\code{res}}{homoscedastic quasi-residuals}
\item{\code{wt}}{robust weights}
\item{\code{rp}}{total number of iteration}
\item{\code{s1}}{changes in scale through iterative calculation}
\item{\code{efg}}{error flag. 1: acalculia (all weights become zero)  0: successful termination}
}
\description{
Robust estimator for a generalized ratio model
with Tukey biweight function and AAD scale
by iteratively re-weighted least squares (IRLS) algorithm for M-estimation
}
