% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBINFast.R
\name{robinCompareFast}
\alias{robinCompareFast}
\title{robinCompareFast}
\usage{
robinCompareFast(
  graph,
  method1 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args1 = list(),
  method2 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args2 = list(),
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  FUN1 = NULL,
  FUN2 = NULL,
  verbose = TRUE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method1}{The first clustering method, one of "walktrap", 
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{args1}{A \code{list} of arguments to be passed to the \code{method1} 
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{method2}{The second custering method one of "walktrap",
"edgeBetweenness","fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{args2}{A \code{list} of arguments to be passed to the \code{method2}
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{FUN1}{personal designed function when \code{method1} is "others". 
see \code{\link{methodCommunity}}.}

\item{FUN2}{personal designed function when \code{method2} is "others". 
see \code{\link{methodCommunity}}.}

\item{verbose}{flag for verbose output (default as TRUE).}

\item{BPPARAM}{the BiocParallel object of class \code{bpparamClass} that 
specifies the back-end to be used for computations. See
  \code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
A list object with two matrices:
- the matrix "Mean1" with the means of the procedure for the first method 
- the matrix "Mean2" with the means of the procedure for the second method
}
\description{
This function compares two community detection algorithms.
Is the parallelized and faster version of \code{\link{robinCompare}}
}
\keyword{internal}
