% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_latex.R
\name{to_latex}
\alias{to_latex}
\alias{to_latex.test_mediation}
\alias{to_latex.summary_test_mediation}
\alias{to_latex.list}
\title{'LaTeX' table of results from (robust) mediation analysis}
\usage{
to_latex(object, ...)

\method{to_latex}{test_mediation}(object, type = c("boot", "data"), ...)

\method{to_latex}{summary_test_mediation}(object, p_value = TRUE, align = c("lrrrr", "c"), ...)

\method{to_latex}{list}(
  object,
  type = c("boot", "data"),
  p_value = TRUE,
  orientation = c("landscape", "portrait"),
  align = NULL,
  ...
)
}
\arguments{
\item{object}{an object inheriting from class
\code{"\link[robmed]{test_mediation}"} or
\code{"\link[robmed:summary.test_mediation]{summary_test_mediation}"}
containing results from (robust) mediation analysis, or a list of such
objects (typically obtained via different procedures for mediation
analysis).  In case of a named list, the supplied names are used as labels
in the resulting \proglang{LaTeX} table, otherwise default labels are
constructed based on how the mediation model was fitted and which type of
test was used (e.g., \code{"ROBMED"} or \code{"OLS Bootstrap"}).}

\item{\dots}{additional arguments to be passed down, eventually to
\code{\link[base]{formatC}()} for formatting numbers.  In particular,
argument \code{digits} can be used to customize the number of digits after
the decimal point (defaults to 3).  Also note that argument \code{big.mark}
is ignored for the numbers in the table; it is only used for formatting the
sample size and (if applicable) the number of bootstrap samples in the table
note.}

\item{type}{a character string specifying which estimates and significance
tests to report if mediation analysis was done via a bootstrap procedure.
If \code{"boot"} (the default), the means of the bootstrap replicates are
reported as point estimates for all effects, and significance tests for the
total and direct effects use the normal approximation of the bootstrap
distribution (i.e., the tests assume a normal distribution of the
corresponding effect with the standard deviation computed from the bootstrap
replicates).  If \code{"data"}, the point estimates on the original data are
reported for all effects, and the significance tests for the total and
direct effects are based on statistical theory (e.g., t-tests if the
coefficients are estimated via regression).  Note that for bootstrap
procedures, significance of the indirect effect is always reported via a
percentile-based confidence interval due to the asymmetry of its
distribution.}

\item{p_value}{a logical indicating whether to include p-values for the
indirect effects if mediation analysis was done via a bootstrap procedure.
If \code{TRUE} (the default), the p-values are obtained via
\code{\link[robmed]{p_value}()}.}

\item{align}{a character vector of length two.  The first element is used
as the alignment specification in the \code{\\begin\{tabular\}\{\}}
statement, while the second element is used for the alignment specification
in \code{\\multicolumn\{\}\{\}\{\}} statements in case of bootstrapped
confidence intervals of the indirect effect.  For the former, note that
if \code{object} is a list of objects and \code{orientation} is
\code{"landscape"}, two empty columns are inserted in the \code{LaTeX}
table.  It is not recommended to set this argument unless you know what
you are doing.}

\item{orientation}{a character string specifying how to arrange the results
from different objects (list elements) in the \proglang{LaTeX} table.  If
\code{"landscape"} (the default), results from two objects are arranged next
to each other with the results from remaining objects underneath (in groups
of two), which is intended for documents in landscape mode (or
\proglang{LaTeX} table environments such as \code{sidewaystable}).  If
\code{"portrait"}, results from different objects are arranged underneath
one another, which is intended for documents in portrait mode.}
}
\value{
An object of class \code{"mediation_latex_tables"} with the following
components:
\item{labels}{a character string giving the labels to be used in the
\proglang{LaTeX} table (only returned if a list of objects is supplied).}
\item{total}{a data frame containing a tabular summary of the total effects,
or a list of such data frames.}
\item{direct}{a data frame containing a tabular summary of the direct
effects, or a list of such data frames.}
\item{indirect}{a data frame containing a tabular summary of the indirect
effects, or a list of such data frames.}
\item{x, m, y, covariates}{character vectors specifying the respective
variables used.}
\item{n}{a character string containing the (formatted) sample size.}
\item{R}{a character string containing the (formatted) number of bootstrap
samples (only returned if applicable).}
\item{orientation}{a character string specifying how to arrange the results
from different objects in the \proglang{LaTeX} table (only returned if a
list of objects is supplied).}
\item{align}{a character vector of length two. The first element gives the
alignment specification to be used in the \code{\\begin\{tabular\}\{\}}
statement, while the second element gives the alignment specification to be
used in \code{\\multicolumn\{\}\{\}\{\}} statements for any bootstrapped
confidence intervals of the indirect effect.}
}
\description{
Generate \proglang{LaTeX} code for a tabular summary of results from
(robust) mediation analysis in the form of a \code{tabular} environment.
This \code{tabular} environment can easily be integrated into a dynamic
\proglang{LaTeX} document with tools such as package \pkg{knitr}, which
eliminates the risk of mistakes in reporting that stem from
copying-and-pasting results.  Note that \code{to_latex()} itself does not
actually produce any \proglang{LaTeX} code, it is the \code{print()} method
of the resulting object that prints the code for the \code{tabular}
environment.
}
\note{
The \code{print()} method for class \code{"mediation_latex_tables"} prints
the \proglang{LaTeX} code for the \code{tabular} environment.  It ignores
any additional arguments, and it returns the supplied object invisibly.
}
\examples{
data("BSG2014")

# seed to be used for the random number generator
seed <- 20150601

# perform mediation analysis via robust bootstrap test ROBMED
set.seed(seed)
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# note that depending on the seed of the random number
# generator, the p value of the indirect effect may fall
# below or above the arbitrary 5\% threshold

# construct LaTeX table of results
to_latex(robust_boot)

# perform mediation analysis via the OLS bootstrap
set.seed(seed)
ols_boot <- test_mediation(BSG2014,
                           x = "ValueDiversity",
                           y = "TeamCommitment",
                           m = "TaskConflict",
                           robust = FALSE)

# construct LaTeX table of results from both procedures
boot_list <- list(ols_boot, robust_boot)
to_latex(boot_list)

# customize labels for procedures and number of digits
boot_list_named <- list("Non-robust" = ols_boot,
                        "Robust" = robust_boot)
to_latex(boot_list_named, digits = 4)

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022a) A Robust Bootstrap Test
for Mediation Analysis.  \emph{Organizational Research Methods},
\bold{25}(3), 591--617.  doi:10.1177/1094428121999096.

Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022b) Robust Mediation Analysis:
The \R Package \pkg{robmed}.  \emph{Journal of Statistical Software},
\bold{103}(13), 1--45.  doi:10.18637/jss.v103.i13.
}
\seealso{
\code{\link[robmed]{test_mediation}()},
\code{\link[robmed:summary.test_mediation]{summary}()}

\code{\link{to_flextable}()}
}
\author{
Andreas Alfons
}
