#' Simulated Pharmaceutical Manufacturing Data
#'
#' This dataset contains simulated pharmaceutical manufacturing data generated by
#' `simulate_pharma_batches()` with `seed = 780` and `obs_per_batch = 30`.
#'
#' Phase 1 includes 10 under-control batches with natural variability in mean and covariance,
#' without contamination.
#'
#' Phase 2 includes 2 additional under-control batches and 3 out-of-control batches.
#' The out-of-control batches exhibit shifts in both mean and variability,
#' along with moderate contamination in a portion of their observations.
#'
#' Each batch contains 30 observations measured across four quantitative quality-control variables.
#'
#' @format A data frame with 450 rows and 7 variables:
#' \describe{
#'   \item{Batch}{Batch identifier (factor)}
#'   \item{Phase}{Phase indicator: "Phase 1" or "Phase 2" (factor)}
#'   \item{Status}{Batch status: "Under Control" or "Out of Control" (factor)}
#'   \item{Concentration}{Concentration of active ingredient (mg/mL)}
#'   \item{Humidity}{Humidity percentage (% w/w)}
#'   \item{Dissolution}{Dissolution percentage (% released)}
#'   \item{Density}{Density (g/cm\eqn{^3})}
#' }
#'
#' @source Simulated using \code{\link{simulate_pharma_batches}} with \code{seed = 780} and \code{obs_per_batch = 30}.
#' @usage data("pharma_data")
#' @keywords datasets
#' @name pharma_data
#' @docType data
"pharma_data"
