test_that("datasets are sane", {
  items <- tryCatch(utils::data(package = "robustfa")$results[, "Item"], error = function(e) character())
  for (d in items) {
    expect_error(utils::data(list = d, package = "robustfa"), NA)
    obj <- get(d, envir = .GlobalEnv, inherits = FALSE)
    expect_false(is.null(obj))
    if (is.data.frame(obj)) {
      expect_gte(nrow(obj), 1)
      expect_gte(ncol(obj), 1)
      expect_true(any(colSums(!is.na(obj)) > 0))
    } else if (is.matrix(obj)) {
      expect_gte(nrow(obj), 1)
      expect_gte(ncol(obj), 1)
    } else if (is.vector(obj)) {
      expect_gte(length(obj), 1)
    }
    rm(list = d, envir = .GlobalEnv)
  }
})
