% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordwrap_source.R
\name{wordwrap_source}
\alias{wordwrap_source}
\title{Wordwrapping a source}
\usage{
wordwrap_source(
  input,
  output = NULL,
  length = 40,
  removeNewlines = FALSE,
  removeTrailingNewlines = TRUE,
  rlWarn = rock::opts$get(rlWarn),
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent),
  utteranceMarker = rock::opts$get("utteranceMarker")
)
}
\arguments{
\item{input}{For \code{clean_source} and \code{search_and_replace_in_source}, either a character
vector containing the text of the relevant source \emph{or} a path to a file that contains
the source text; for \code{clean_sources} and \code{search_and_replace_in_sources}, a path to a
directory that contains the sources to clean.}

\item{output}{For \code{clean_source} and \code{search_and_replace_in_source}, if not \code{NULL},
this is the name (and path) of the file in which to save the processed source (if it
\emph{is} \code{NULL}, the result will be returned visibly). For \code{clean_sources} and
\code{search_and_replace_in_sources}, \code{output} is mandatory and is the path to the
directory where to store the processed sources. This path will be created with a
warning if it does not exist. An exception is if "\code{same}" is specified - in that
case, every file will be written to the same directory it was read from.}

\item{length}{At how many characters to word wrap.}

\item{removeNewlines}{Whether to remove all newline characters from the source before
starting to clean them. \strong{Be careful}: if the source contains YAML fragments, these
will also be affected by this, and will probably become invalid!}

\item{removeTrailingNewlines}{Whether to remove trailing newline characters
(i.e. at the end of a character value in a character vector);}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{encoding}{The encoding of the source(s).}

\item{silent}{Whether to suppress the warning about not editing the cleaned source.}

\item{utteranceMarker}{The character(s) between utterances (i.e. marking where
one utterance ends and the next one starts). By default, this is a line
break, and only change this if you know what you are doing.}
}
\value{
A character vector.
}
\description{
This function wordwraps a source.
}
\examples{
exampleText <-
  paste0(
    "Lorem ipsum dolor sit amet, consectetur ",
    "adipiscing elit. Nunc non commodo ex, ac ",
    "varius mi. Praesent feugiat nunc eget urna ",
    "euismod lobortis. Sed hendrerit suscipit ",
    "nisl, ac tempus magna porta et. ",
    "Quisque libero massa, tempus vel tristique ",
    "lacinia, tristique in nulla. Nam cursus enim ",
    "dui, non ornare est tempor eu. Vivamus et massa ",
    "consectetur, tristique magna eget, viverra elit."
  );

### Show example text
cat(exampleText);

### Show preprocessed example text
cat(
  paste0(
    rock::wordwrap_source(
      exampleText
    ),
    collapse = "\n"
  )
);
}
