% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessions.R
\name{rockr.session_switch}
\alias{rockr.session_switch}
\title{Switch R session}
\usage{
rockr.session_switch(conn, session)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{session}{A R session object.}
}
\value{
Void
}
\description{
Change the R session that is attached to the connection object. This allows to interact with a R session
after another. Of course proper permission apply when executing R operations on this R session.
}
\examples{
\dontrun{
conn <- rockr.connect(username='administrator', password='password',
                      url='https://rocker-demo.obiba.org')
# open several R sessions
rockr.open(conn)
rockr.open(conn)
sessions <- rockr.sessions(conn)
# switch to first one
rockr.session_switch(conn, sessions[[1]])
conn$session
rockr.close(conn)
# switch to 2nd one
rockr.session_switch(conn, sessions[[2]])
conn$session
rockr.close(conn)
}
}
\seealso{
Other administration functions: 
\code{\link{rockr.log}()},
\code{\link{rockr.package_install}()},
\code{\link{rockr.package_rm}()},
\code{\link{rockr.packages_datashield}()},
\code{\link{rockr.packages_rm}()},
\code{\link{rockr.packages}()},
\code{\link{rockr.package}()},
\code{\link{rockr.restart}()},
\code{\link{rockr.sessions}()},
\code{\link{rockr.session}()},
\code{\link{rockr.start}()},
\code{\link{rockr.status}()},
\code{\link{rockr.stop}()},
\code{\link{rockr.version}()}
}
\concept{administration functions}
