% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{rockr.stop}
\alias{rockr.stop}
\title{Stop the R server}
\usage{
rockr.stop(conn)
}
\arguments{
\item{conn}{A rockr connection object.}
}
\value{
Logical indicating wether the R server is running (invisible).
}
\description{
Stop the R server, if running. Any R sessions will be closed.
}
\examples{
\dontrun{
conn <- rockr.connect(username='administrator', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.stop(conn)
}
}
\seealso{
Other administration functions: 
\code{\link{rockr.log}()},
\code{\link{rockr.package_install}()},
\code{\link{rockr.package_rm}()},
\code{\link{rockr.packages_datashield}()},
\code{\link{rockr.packages_rm}()},
\code{\link{rockr.packages}()},
\code{\link{rockr.package}()},
\code{\link{rockr.restart}()},
\code{\link{rockr.session_switch}()},
\code{\link{rockr.sessions}()},
\code{\link{rockr.session}()},
\code{\link{rockr.start}()},
\code{\link{rockr.status}()},
\code{\link{rockr.version}()}
}
\concept{administration functions}
