% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocsvm.intercept.R
\name{rocsvm.intercept}
\alias{rocsvm.intercept}
\title{Finding an intercept fixed sensitivity or specificity for ROC-SVM}
\usage{
rocsvm.intercept(obj, lambda = 1, sensitivity = 0.5, specificity = 0.5)
}
\arguments{
\item{obj}{The rocsvm.path object}

\item{lambda}{The regularization parameter that users want in ROC-SVM model.}

\item{sensitivity}{Sensitivity in ROC curve, which means True Positive Rate (TPR).}

\item{specificity}{Specificity in ROC curve, which means True Negative Rate (TNR) = 1-FPR.}
}
\description{
Computes an intercept at a specific sensitivity or specificity level from the ROC-SVM model.
}
\examples{
# library(rocsvm.path)
# The 'obj' comes from an example description of rocsvm.path()
\donttest{
rocsvm.intercept(obj, lambda = 1, sensitivity = 0.9, specificity = 0.1) }
}
\seealso{
\code{\link{rocsvm.path}}
}
\author{
Seung Jun Shin, Do Hyun Kim
}
