% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rope.R
\name{explore}
\alias{explore}
\title{Run first step of model fitting to find good penalization interval}
\usage{
explore(data, B, mc.cores = getOption("mc.cores", 2L))
}
\arguments{
\item{data}{Matrix of variable presence counts. One column for each variable,
one row for each parameter value (e.g. levels of regularization).}

\item{B}{Number of bootstraps used to construct \code{data}. At least 21 are
needed for u-shape test heuristic to work, but in general it is recommended
to use many more.}

\item{mc.cores}{Number of threads to run in parallel (1 turns of
parallelization)}
}
\value{
A list with components
  \item{pop.sep}{vector of values saying how separated true and false
    variables are for each level of penalization}
}
\description{
Run first step of model fitting to find good penalization interval
}
