% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_premium_est.R
\name{call.premium.est}
\alias{call.premium.est}
\title{Estimated Premium of Option Contract}
\usage{
call.premium.est(s, k, t, sd, r, d = 0)
}
\arguments{
\item{s}{Spot Price of Underlying Asset}

\item{k}{Exercise Price of Contract}

\item{t}{Time to Expiration}

\item{sd}{Volatality}

\item{r}{Risk free rate of return}

\item{d}{Divident Yield (use cont.rate()), Default: 0}
}
\value{
Output gives the Estimated Premium of a Option Contract.
}
\description{
Calculate the Estimated Premium of Option Contract
}
\details{
Estimate is calculated based on Black-Scholes Model. The Black Scholes model, also known as the Black-Scholes-Merton (BSM) model, is a mathematical model for pricing an options contract.
}
\examples{
call.premium.est(100, 105, 0.25, 0.35, 0.0488)
}
