% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_fact.R
\name{random_fact}
\alias{random_fact}
\title{Random Chuck Norris facts}
\usage{
random_fact(
  n = 1L,
  include = NULL,
  exclude = NULL,
  sound = FALSE,
  sound_repeat = 1
)
}
\arguments{
\item{n}{Integer specifying the number of random facts to return. Default is
\code{1}.}

\item{include}{Character string specifying the category of the joke. Default
is \code{NULL} meaning use all available categories in the query. The
available categories can be viewed using \code{fetch_categories()}.
(Currently ignored.)}

\item{exclude}{Character string specifying the categories to exclude.
Default is \code{NULL} meaning use all available categories in the query.
The available categories can be viewed using \code{fetch_categories()}.
(Currently ignored.)}

\item{sound}{Logical indicating whether or not "Chuck Norris" should be
shouted when generating random facts. Default is \code{FALSE}.}

\item{sound_repeat}{Integer specifying the number of times the sound should
be repeated. Default is 1. (Only matters if \code{sound = TRUE}.)}
}
\value{
An object of class \code{"random_fact"}; essentially a character
vector.
}
\description{
Query the internet Chuck Norris database (ICNDb) for a random Chuck Norris
fact.
}
\examples{
\dontrun{
# Generate a random fact
random_fact()

# Generate multiple random facts
random_fact(3, sound = TRUE)
}
}
