% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutines.R
\name{calc_kmm}
\alias{calc_kmm}
\title{Calculates the Michaelis Menten coefficient for Rubisco-limited photosynthesis}
\usage{
calc_kmm(tc, patm)
}
\arguments{
\item{tc}{Temperature, relevant for photosynthesis (deg C)}

\item{patm}{Atmospheric pressure (Pa)}
}
\value{
A numeric value for \eqn{K} (in Pa)
}
\description{
Calculates the Michaelis Menten coefficient of Rubisco-limited assimilation
as a function of temperature and atmospheric pressure.
}
\details{
The Michaelis-Menten coefficient \eqn{K} of Rubisco-limited
photosynthesis is determined by the Michalis-Menten constants for
O2 and CO2 (Farquhar, 1980) according to:
\deqn{
  K = Kc ( 1 + pO2 / Ko)
}
where \eqn{Kc} is the Michaelis-Menten constant for CO2 (Pa), \eqn{Ko} is
the Michaelis-Menten constant for O2 (Pa), and \eqn{pO2} is the partial
pressure of oxygen (Pa), calculated as \eqn{0.209476 p}, where \eqn{p} is
given by argument \code{patm}.  \eqn{Kc} and \eqn{Ko} follow a temperature
dependence, given by the Arrhenius Equation \eqn{f} (implemented by
\link{ftemp_arrh}):
\deqn{
   Kc = Kc25 f(T, \Delta Hkc)
}
\deqn{
   Ko = Ko25 f(T, \Delta Hko)
}
Values \eqn{\Delta Hkc} (79430 J mol-1), \eqn{\Delta Hko} (36380 J mol-1),
\eqn{Kc25} (39.97 Pa), and \eqn{Ko25} (27480 Pa) are taken from Bernacchi
et al. (2001) and have been converted from values given therein to units of Pa
by multiplication with the standard atmosphere (101325 Pa). \eqn{T} is given
by the argument \code{tc}.
}
\examples{
print("Michaelis-Menten coefficient at 20 degrees Celsius and standard atmosphere (in Pa):")
print(calc_kmm(20, 101325))

}
\references{
Farquhar,  G.  D.,  von  Caemmerer,  S.,  and  Berry,  J.  A.:
            A  biochemical  model  of photosynthetic CO2 assimilation in leaves of
            C 3 species, Planta, 149, 78–90, 1980.

            Bernacchi,  C.  J.,  Singsaas,  E.  L.,  Pimentel,  C.,  Portis,  A.
            R.  J.,  and  Long,  S.  P.:Improved temperature response functions
            for models of Rubisco-limited photosyn-thesis, Plant, Cell and
            Environment, 24, 253–259, 2001
}
