% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_mean_variance.R
\name{local_mean_variance}
\alias{local_mean_variance}
\title{Variance estimator for spatially balanced samples}
\usage{
local_mean_variance(values, probabilities, spread_mat, neighbours = 4L)
}
\arguments{
\item{values}{A vector of values of the variable of interest.}

\item{probabilities}{A vector of inclusion probabilities.}

\item{spread_mat}{A matrix of spreading covariates.}

\item{neighbours}{The number of neighbours to construct the means around.}
}
\value{
A vector of sample indices.
}
\description{
Variance estimator of HT estimator of population total.
}
\examples{
set.seed(12345);
N = 1000;
n = 100;
prob = rep(n/N, N);
xs = matrix(runif(N * 2), ncol = 2);
y = runif(N);

s = lpm_2(prob, xs);
local_mean_variance(y[s], prob[s], xs[s, ], 4);

\donttest{
# Compare SRS, empirical
r = 1000L;
v = matrix(0.0, r, 3L);

for (i in seq_len(r)) {
  s = lpm_2(prob, xs);
  v[i, 1] = local_mean_variance(y[s], prob[s], xs[s, ], 4);
  v[i, 2] = N^2 * sd(y[s]) / n;
  v[i, 3] = sum(y[s] / prob[s]);
}

# Local mean variance, SRS variance, MSE
print(c(mean(v[, 1]), mean(v[, 2]), mean((v[, 3] - sum(y))^2)));
}

}
\references{
Grafström, A., & Schelin, L. (2014).
How to select representative samples.
Scandinavian Journal of Statistics, 41(2), 277-290.
}
