% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snell.R
\name{snell}
\alias{snell}
\title{Calculate Snell scores}
\usage{
snell(table)
}
\arguments{
\item{table}{a frequency table with group labels in rows and the original scores in columns.
This can be derived using the buildfreqtable function.}
}
\value{
a vector of scores corresponding to the columns of the input frequency table.
}
\description{
This function calculates Snell scores given counts of scores by subpopulation
}
\examples{
library(dplyr)
mydata <- data.frame("Groups" = rep(c("A", "B", "C", "D"), 10),
                     "Scores" = round(runif(40, 0, 5)))
freqtable <- buildfreqtable(data = mydata, trait = "Scores", subgroup = "Groups")
snell(freqtable)

}
\references{
http://140.136.247.242/~stat2016/stat/NoteOnSnellComp.pdf
}
