% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections-funs.R
\name{collections_functions}
\alias{collections_functions}
\alias{collections_next}
\alias{collections_matched}
\alias{collections_length}
\alias{collections_fetch}
\title{Collections functions}
\usage{
collections_next(collections, ...)

collections_matched(collections, matched_field)

collections_length(collections)

collections_fetch(collections, ..., progress = TRUE, matched_field = NULL)
}
\arguments{
\item{collections}{a \code{doc_collections} object.}

\item{...}{additional arguments. See details.}

\item{matched_field}{a \code{character} vector with the path
where is the number of collections returned.}

\item{progress}{a \code{logical} indicating if a progress bar must be
shown or not. Defaults to \code{TRUE}.}
}
\value{
\itemize{
\item \code{collections_length()}: an \code{integer} value.

\item \code{collections_matched()}: returns an \code{integer} value if the STAC web
server does support this extension. Otherwise returns \code{NULL}.

\item \code{collections_fetch()}: a \code{doc_items} with all matched items.

\item \code{collections_next()}: fetches a new page from STAC service.

}
}
\description{
These functions provide support to work with
\code{doc_collections}objects.

\itemize{
\item \code{collections_length()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
shows how many items there are in the \code{doc_items} object.

\item \code{collections_matched()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
shows how many items matched the search criteria.

\item \code{collections_fetch()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
request all STAC Items through pagination.

\item \code{collections_next()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
fetches a new page from STAC service.

}
}
\details{
Ellipsis argument (\code{...}) appears in different items functions and
has distinct purposes:

\itemize{
\item \code{collections_fetch()} and \code{collections_next()}: ellipsis is used to
pass additional \code{httr} options to \link[httr:GET]{GET} method, such as
\link[httr:add_headers]{add_headers} or \link[httr:set_cookies]{set_cookies}.

}
}
\examples{
\dontrun{
# doc_items object
stac("https://cmr.earthdata.nasa.gov/stac/LPCLOUD") |>
  collections() |>
  get_request() |>
  collections_fetch()
}

}
