#' Functions for the design of CCD experiments and the analysis of CCD experimental data
#'
#' A package for the planning of experiments following rotatable central composite designs
#' (CCDs) and the analysis of CCD experimental data with response surface methodology.
#'
#' @section Functions:
#'
#'\command{design_ccd()}, for the number of values and the experimental uncoded values for
#'    each of the k quantitative factors
#'
#'\command{ccd_analysis()}, for response surface analysis, including the regression model
#'    fitting and plot of the fitted response surface
#'
#'@section References:
#'
#'Mead, R., Gilmour, S. G., and Mead, A. 2012. Statistical Principles for the Design of
#'    Experiments: Applications to Real Experiments. Cambridge University Press, Cambridge.
#'
#'Panneton, B., Philion, H., Dutilleul, P., Theriault, R., and Khelifi, M. 1999. Full factorial
#'    design versus central composite design: Statistical comparison and experimental
#'    implications for spray droplet deposition. Transactions of the American Society of
#'    Agricultural Engineers 42:877-883.
#'
#' @docType package
#' @name rsurface
NULL
