% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_column_defaults}
\alias{set_column_defaults}
\title{Set column defaults}
\usage{
set_column_defaults(
  widget,
  editor = FALSE,
  header_filter = FALSE,
  header_sort = TRUE,
  tooltip = TRUE,
  width = NULL,
  ...
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{editor}{(character, bool): One of \code{"input"} or \code{"number"}.
If set to \code{FALSE} cells are not editable.}

\item{header_filter}{(character, bool): One of \code{"input"} or \code{"number"}.
Set to \code{FALSE} to disable header filters.}

\item{header_sort}{(bool): Whether to enable header sorting.}

\item{tooltip}{(bool): Whether to show tooltips displaying the cell value.}

\item{width}{(integer): Fixed width of columns.}

\item{...}{Additional settings.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set column defaults
}
\examples{
tabulator(iris, theme = "simple") |>
  set_column_defaults(
    header_filter = TRUE,
    header_sort = FALSE,
    tooltip = TRUE
  )
}
\seealso{
\url{https://tabulator.info/docs/6.2/columns#defaults}
}
