% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_textarea}
\alias{set_formatter_textarea}
\title{Set text area formatter}
\usage{
set_formatter_textarea(widget, column, hoz_align = "left")
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set text area formatter
}
\examples{
data <- data.frame(
  id = c(1, 2),
  txt = c(
    "This\nis\nsome\ntext\nwith\nmultiple\nline\nbreaks",
    "- R\n- Python\n- Julia"
  )
)

tabulator(data, width = 200) |>
  set_formatter_textarea("txt")
}
