% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulator_options.R
\name{set_options_pagination}
\alias{set_options_pagination}
\title{Set pagination options}
\usage{
set_options_pagination(
  widget,
  pagination = TRUE,
  pagination_size = 10,
  pagination_size_selector = FALSE,
  pagination_add_row = c("page", "table"),
  ...
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{pagination}{(bool): Whether to enable pagination.}

\item{pagination_size}{(integer): Number of rows on each page.}

\item{pagination_size_selector}{(list): Add pagination size selector.}

\item{pagination_add_row}{(character): Where to add rows to the table when pagination is enabled.}

\item{...}{Further options.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set pagination options
}
\examples{
tabulator(iris) |>
  set_options_pagination(pagination_size_selector = c(10, 20, 50))
}
