% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulator_options.R
\name{tabulator_options}
\alias{tabulator_options}
\title{Setup options for \code{tabulator()} HTML widget}
\usage{
tabulator_options(
  height = "311px",
  history = FALSE,
  columns = NULL,
  layout = c("fitColumns", "fitData", "fitDataFill", "fitDataStretch", "fitDataTable"),
  responsive_layout = FALSE,
  movable_columns = FALSE,
  header_visible = TRUE,
  row_height = NULL,
  add_row_pos = c("bottom", "top"),
  movable_rows = FALSE,
  resizable_rows = FALSE,
  frozen_rows = NULL,
  index = "id",
  group_by = NULL,
  group_start_open = TRUE,
  group_toggle_element = NULL,
  edit_trigger_event = c("dblclick", "click", "focus"),
  selectable_rows = "highlight",
  pagination = FALSE,
  pagination_size = 10,
  pagination_size_selector = FALSE,
  pagination_add_row = c("page", "table"),
  spreadsheet = FALSE,
  spreadsheet_rows = NULL,
  spreadsheet_columns = NULL,
  spreadsheet_column_definition = NULL,
  spreadsheet_sheets = NULL,
  spreadsheet_sheet_tabs = NULL,
  ...
)
}
\arguments{
\item{height}{(character) The height of the table in pixels.}

\item{history}{(bool): Enable user interaction history functionality.}

\item{columns}{(list): Column definitions.
If set to \code{NULL}, definitions are auto generated from table data.}

\item{layout}{(character): Layout mode of the table columns.}

\item{responsive_layout}{(bool): Automatically hide and show columns to fit
the width of the Tabulator element.}

\item{movable_columns}{(bool): Allow users to move and reorder rows.}

\item{header_visible}{(bool): Whether header is visible.}

\item{row_height}{(numeric): A fixed height of the rows.}

\item{add_row_pos}{(character): The table position where new rows are added.}

\item{movable_rows}{(bool): Allow users to move and reorder rows.}

\item{resizable_rows}{(bool): Allow user to resize rows.}

\item{frozen_rows}{(numeric): Number of frozen rows.}

\item{index}{(character): Field to be used as the unique index for each row.}

\item{group_by}{(character vector): Field to group rows by. Pass multiple values
for multi level grouping.}

\item{group_start_open}{(bool vector): Open state of groups when grouping is enabled.
The length of the vector depends on the number of levels set with \code{group_by}.}

\item{group_toggle_element}{(character, bool): One of \code{arrow} or \code{header}.
Set to \code{FALSE} to disable toggling at all.}

\item{edit_trigger_event}{(character): Event that triggers a cell edit.}

\item{selectable_rows}{(character, bool, integer) Set to \code{FALSE} to disble row selection.
If set to \code{TRUE}, you can select as many rows as you want.
If set to \code{"highlight"}, rows are just highlighted but do not change state when clicked.
An integer value sets the maximum number of rows that can be selected.}

\item{pagination}{(bool): Whether to enable pagination.}

\item{pagination_size}{(integer): Number of rows on each page.}

\item{pagination_size_selector}{(list): Add pagination size selector.}

\item{pagination_add_row}{(character): Where to add rows to the table when pagination is enabled.}

\item{spreadsheet}{(bool): Whether to enable spreadsheet mode.}

\item{spreadsheet_rows}{(integer): Number of spreadsheet rows.}

\item{spreadsheet_columns}{(integer): Number of spreadsheet columns.}

\item{spreadsheet_column_definition}{Column definition used for all columns in the sheet.}

\item{spreadsheet_sheets}{(list): List of sheet definitions.}

\item{spreadsheet_sheet_tabs}{(bool): Whether to show sheet tabs in the footer.}

\item{...}{Further options.}
}
\value{
list with setup options to be used as \code{options} parameter in \code{\link[=tabulator]{tabulator()}}
}
\description{
Setup options for \code{tabulator()} HTML widget
}
\examples{
setup <- tabulator_options(
  group_by = "Species",
  pagination = TRUE,
  pagination_size = 10,
  pagination_size_selector = c(10, 20, 50),
  movable_columns = TRUE,
  movable_rows = TRUE
)
tabulator(iris, setup)
}
\seealso{
\url{https://tabulator.info/docs/6.2/options} for a complete list of available options
}
