% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context_calls.R
\name{trigger_download}
\alias{trigger_download}
\title{Download table data}
\usage{
trigger_download(ctx, type = c("csv", "json", "xlsx"), file_name = NULL)
}
\arguments{
\item{ctx}{A \code{\link[=tabulatorContext]{tabulatorContext()}} object.}

\item{type}{File format.}

\item{file_name}{File name. Set to \code{"data.{type}"} if \code{file_name = NULL}.}
}
\value{
A \code{\link[=tabulatorContext]{tabulatorContext()}} object
}
\description{
Download table data
}
\details{
If you want to support \code{xlsx} downloads, you need to include
the \href{https://sheetjs.com/}{sheetjs} HTML dependency with \code{tabulator(..., sheetjs = TRUE)}.
}
\examples{
\donttest{
tabulatorContext("table") |>
  trigger_download("csv", "table-data.csv")
}
}
