% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{countryExData}
\alias{countryExData}
\title{Example dataset for country level data (2008 Environmental Performance
Index)}
\format{
A data frame with 149 observations on the following 80 variables.
\describe{ \item{ISO3V10}{a character vector}
\item{Country}{a character vector} \item{EPI_regions}{a
character vector} \item{GEO_subregion}{a character vector}
\item{Population2005}{a numeric vector}
\item{GDP_capita.MRYA}{a numeric vector} \item{landlock}{a
numeric vector} \item{landarea}{a numeric vector}
\item{density}{a numeric vector} \item{EPI}{a numeric
vector} \item{ENVHEALTH}{a numeric vector}
\item{ECOSYSTEM}{a numeric vector} \item{ENVHEALTH.1}{a
numeric vector} \item{AIR_E}{a numeric vector}
\item{WATER_E}{a numeric vector} \item{BIODIVERSITY}{a
numeric vector} \item{PRODUCTIVE_NATURAL_RESOURCES}{a numeric
vector} \item{CLIMATE}{a numeric vector} \item{DALY_SC}{a
numeric vector} \item{WATER_H}{a numeric vector}
\item{AIR_H}{a numeric vector} \item{AIR_E.1}{a numeric
vector} \item{WATER_E.1}{a numeric vector}
\item{BIODIVERSITY.1}{a numeric vector} \item{FOREST}{a
numeric vector} \item{FISH}{a numeric vector}
\item{AGRICULTURE}{a numeric vector} \item{CLIMATE.1}{a
numeric vector} \item{ACSAT_pt}{a numeric vector}
\item{WATSUP_pt}{a numeric vector} \item{DALY_pt}{a numeric
vector} \item{INDOOR_pt}{a numeric vector} \item{PM10_pt}{a
numeric vector} \item{OZONE_H_pt}{a numeric vector}
\item{SO2_pt}{a numeric vector} \item{OZONE_E_pt}{a numeric
vector} \item{WATQI_pt}{a numeric vector} \item{WATSTR_pt}{a
numeric vector} \item{WATQI_GEMS.station.data}{a numeric vector}
\item{FORGRO_pt}{a numeric vector} \item{CRI_pt}{a numeric
vector} \item{EFFCON_pt}{a numeric vector} \item{AZE_pt}{a
numeric vector} \item{MPAEEZ_pt}{a numeric vector}
\item{EEZTD_pt}{a numeric vector} \item{MTI_pt}{a numeric
vector} \item{IRRSTR_pt}{a numeric vector} \item{AGINT_pt}{a
numeric vector} \item{AGSUB_pt}{a numeric vector}
\item{BURNED_pt}{a numeric vector} \item{PEST_pt}{a numeric
vector} \item{GHGCAP_pt}{a numeric vector}
\item{CO2IND_pt}{a numeric vector} \item{CO2KWH_pt}{a
numeric vector} \item{ACSAT}{a numeric vector}
\item{WATSUP}{a numeric vector} \item{DALY}{a numeric
vector} \item{INDOOR}{a numeric vector} \item{PM10}{a
numeric vector} \item{OZONE_H}{a numeric vector}
\item{SO2}{a numeric vector} \item{OZONE_E}{a numeric
vector} \item{WATQI}{a numeric vector}
\item{WATQI_GEMS.station.data.1}{a numeric vector}
\item{WATSTR}{a numeric vector} \item{FORGRO}{a numeric
vector} \item{CRI}{a numeric vector} \item{EFFCON}{a numeric
vector} \item{AZE}{a numeric vector} \item{MPAEEZ}{a numeric
vector} \item{EEZTD}{a numeric vector} \item{MTI}{a numeric
vector} \item{IRRSTR}{a numeric vector} \item{AGINT}{a
numeric vector} \item{AGSUB}{a numeric vector}
\item{BURNED}{a numeric vector} \item{PEST}{a numeric
vector} \item{GHGCAP}{a numeric vector} \item{CO2IND}{a
numeric vector} \item{CO2KWH}{a numeric vector} }
}
\source{
http://epi.yale.edu/Downloads
}
\description{
A dataframe containing example country level data for 149 countries.  This
is the 2008 Environmental Performance Index (EPI) downloaded from
http://epi.yale.edu/.  Used here with permission, further details on the
data can be found there.  The data are referenced by ISO 3 letter country
codes and country names.
}
\details{
2008 Environmental Performance Index (EPI) data downloaded from :
http://epi.yale.edu/Downloads

Disclaimers This 2008 Environmental Performance Index (EPI) tracks national
environmental results on a quantitative basis, measuring proximity to an
established set of policy targets using the best data available. Data
constraints and limitations in methodology make this a work in progress.
Further refinements will be undertaken over the next few years.  Comments,
suggestions, feedback, and referrals to better data sources are welcome at:
http://epi.yale.edu or epi@yale.edu.
}
\examples{

data(countryExData,envir=environment(),package="rworldmap")
str(countryExData)

}
\references{
Esty, Daniel C., M.A. Levy, C.H. Kim, A. de Sherbinin, T.
Srebotnjak, and V. Mara. 2008.  2008 Environmental Performance Index. New
Haven: Yale Center for Environmental Law and Policy.
}
\keyword{datasets}
