% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FactorAnalyses.R
\name{FactorAnalyses}
\alias{FactorAnalyses}
\title{Construct a poset of factor analysis models.}
\usage{
FactorAnalyses(numCovariates = 1, maxNumFactors = 0)
}
\arguments{
\item{numCovariates}{the number of covariates in all of the models.}

\item{maxNumFactors}{the maximum number of factors allowed in a model, will
create a hierarchy of all models with less than or equal
to this number.}
}
\value{
An object representing the collection.
}
\description{
Creates an object representing a collection of factor analysis models. There
is one model for each fixed number of factors from 0 to some specified
maximum number of factors. Each model is identified by a single
number, in particular the model with n factors is associated with the model
numbered (n + 1), this is because we allow a model with 0 factors and would
like all models to be numbered with strictly positive integers for
consistency. Models are naturally ordered by inclusion so that, for example,
a model with 2 factors comes before a model with 3 or more factors.
}

