% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeKclust.R
\name{compute.kclust}
\alias{compute.kclust}
\title{Gram similarity matrix checker}
\usage{
compute.kclust(
  eigenValues,
  method = "default",
  Kmax = 20,
  tolerence = 1,
  threshold = 0.9,
  verbose = FALSE
)
}
\arguments{
\item{eigenValues}{The eigenvalues of the laplacian matrix.}

\item{method}{The method that will be used. "default" to let the function choose the most suitable method. "PEV" for the Principal EigenValue method. "GAP" for the GAP method.}

\item{Kmax}{The maximum number of cluster which is allowed.}

\item{tolerence}{The tolerance allowed for the Principal EigenValue method.}

\item{threshold}{The threshold to select the dominant eigenvalue for the GAP method.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
a vector which contain the number of cluster to compute.
}
\description{
Function which select the number of cluster to compute thanks to a selected method
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
W <- compute.similarity.ZP(scale(sameTwoDisks))
W <- checking.gram.similarityMatrix(W)
eigVal <- compute.laplacian.NJW(W,verbose = TRUE)$eigen$values
K <- compute.kclust(eigVal, method="default", Kmax=20, tolerence=0.99, threshold=0.9, verbose=TRUE)

### Example 2: Speed and Stopping Distances of Cars
W <- compute.similarity.ZP(scale(cars))
W <- checking.gram.similarityMatrix(W)
eigVal <- compute.laplacian.NJW(W,verbose = TRUE)$eigen$values
K <- compute.kclust(eigVal, method="default", Kmax=20, tolerence=0.99, threshold=0.9, verbose=TRUE)
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
