% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeLaplacianNJW.R
\name{compute.laplacian.NJW}
\alias{compute.laplacian.NJW}
\title{Gram similarity matrix checker}
\usage{
compute.laplacian.NJW(W, verbose = FALSE)
}
\arguments{
\item{W}{Gram Similarity Matrix.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{Lsym: }{a NJW laplacian matrix}
 \item{eigen: }{a list that contain the eigenvectors ans eigenvalues}
 \item{diag: }{a diagonal matrix used for the laplacian matrix}
}
}
\description{
Function which select the number of cluster to compute thanks to a selected method
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
W <- compute.similarity.ZP(scale(sameTwoDisks))
W <- checking.gram.similarityMatrix(W)
res <- compute.laplacian.NJW(W,verbose = TRUE)

### Example 2: Speed and Stopping Distances of Cars
W <- compute.similarity.ZP(scale(cars))
W <- checking.gram.similarityMatrix(W)
res <- compute.laplacian.NJW(W,verbose = TRUE)
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
