% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sFFLHD_Lflex.R
\docType{data}
\name{sFFLHD_Lflex}
\alias{sFFLHD_Lflex}
\title{sFFLHD with flexible L}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
sFFLHD_Lflex
}
\value{
A sFFLHD_Lflex object
}
\description{
R6 object that gives uses a sFFLHD with L near the requested one,
but gives them back in the requested L
}
\section{Fields}{

\describe{
\item{\code{D}}{numeric. The number of dimensions for the design. Must be set.}

\item{\code{L}}{numeric. The number of points in each batch, also the number of
levels of each dimension. Must be set.}

\item{\code{b}}{integer. The batch number.}

\item{\code{s}}{sFFLHD. The design it takes the points and then reorders them.}

\item{\code{X}}{matrix. The points given in the design.}

\item{\code{X_choices}}{matrix. Points taken from s and have been reordered,
but which have not been returned to the user yet.}
}}

\examples{
s <- sFFLHD_Lflex$new(D=8,L=4)
s$get.batch()
# sFFLHD(D=7,L=10)$get.batch() doesn't work, needs L=7,8,9,11
s <- sFFLHD_Lflex$new(D=7,L=10) # Uses L=9
s$get.batch()
s <- sFFLHD_Lflex$new(D=7,L=10, prefer_L="up") # Should use 11
}
\keyword{datasets}
