% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filiter.R
\name{Rpmfiliter}
\alias{Rpmfiliter}
\title{Filitering low expressed miRNAs based on RPM: Rpmfiliter}
\usage{
Rpmfiliter(P1_RPM, P2_RPM, F1_RPM, rpm_threshold = 1)
}
\arguments{
\item{P1_RPM}{A dataframe. The rpm data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the rpm of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the P2 species.}

\item{F1_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the F1 species.}

\item{rpm_threshold}{A numeric. the average of rpm value among all the biological replicates. By default, the average of rpm more than or equal to 1 is retained.}
}
\value{
A dataframe. The result includes all miRNAs that fulfill the average rpm value requirement (Average rpm >= rpm_threshold) among all species.
}
\description{
Filitering low expressed miRNAs based on RPM: Rpmfiliter
}
\examples{
##Get the filitered mirna rpm table (default: the average rpm >= 1 in three species)
Rpm1result <- Rpmfiliter(P1_RPM = P1_miRNA_rpm,
                         P2_RPM = P2_miRNA_rpm,
                         F1_RPM = F1_miRNA_rpm,rpm_threshold = 1)
}
