% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srnapredata.R
\name{srnapredata}
\alias{srnapredata}
\title{Generate the data of sRNA length distribution}
\usage{
srnapredata(srnaseq_dataframe, group)
}
\arguments{
\item{srnaseq_dataframe}{A dataframe. The first column must be the sRNA sequence.}

\item{group}{A character. You an select a representative group name for next drawing.}
}
\value{
A dataframe. The output results are consist of three columns, the first column is the length of sRNA, the second column id the frequency, and the third column is the group name.
}
\description{
Generally, the length interval of sRNA is 21-24. The function of "srnapredata" can provide the input data for the next drawing of sRNA length distribution among different species.
}
\examples{
##Only 400 sRNAs are selected as test data due to the large data of sRNA.
##Recommended to use the "data.table" package for reading data quickly.
##F1
F1_sRNA <- srnapredata(srnaseq_dataframe = F1_sRNA_seq, group = "F1")
##P1
P1_sRNA <- srnapredata(srnaseq_dataframe = P1_sRNA_seq, group = "P1")
##P2
P2_sRNA <- srnapredata(srnaseq_dataframe = P2_sRNA_seq, group = "P2")
}
