% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowlevel.R, R/plotfunctions.R
\name{sadforecast}
\alias{sadforecast}
\alias{as.sadforecast}
\alias{plot.sadforecast}
\title{class for a list of forecasts}
\usage{
as.sadforecast(x)

\method{plot}{sadforecast}(x, mfrow = NULL, col = NULL, ...)
}
\arguments{
\item{x}{a list of 2 or more 2D matrices with equal sizes and no missing or inifinite values}

\item{mfrow}{vector with the number of rows and columns you would like in the plot}

\item{col}{color scale for the plot}

\item{...}{further arguments passed to \code{image}}
}
\value{
an object of class \code{sadforecast}
}
\description{
check that a list of forecasts fulfills all requirements to be verified by our method
}
\details{
\code{as.sadforecast} does nothing except check that everything is as it should be, add the attributes that can be changed by \code{prepare_sad} and provide a method for quick plots of the data.
}
\examples{
data( rrain )
ra <- list( rrain[1,1,,], rrain[4,5,,], rrain[2,7,,] )
ra <- as.sadforecast(ra)
plot(ra)
}
