% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.saehb}
\alias{autoplot.saehb}
\title{Autoplot}
\usage{
\method{autoplot}{saehb}(object, ...)
}
\arguments{
\item{object}{HB model}

\item{...}{other argument}
}
\value{
plot
}
\description{
Autoplot
}
\examples{
library(dplyr)

Xarea <- cornsoybeanmeans \%>\%
   dplyr::select(
      County = CountyIndex,
      CornPix = MeanCornPixPerSeg,
      SoyBeansPix = MeanSoyBeansPixPerSeg
   )

corn_model <- hb_unit(
   CornHec ~ SoyBeansPix + CornPix,
   data_unit = cornsoybean,
   data_area = Xarea,
   domain = "County",
   iter.update = 20,
   plot = FALSE
)
autoplot(corn_model)

}
