% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_saekernel.R
\docType{data}
\name{Data_saekernel}
\alias{Data_saekernel}
\title{Sample Data for Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel}
\format{A data frame with 100 rows and 3 variables:
\describe{
  \item{y}{Direct Estimation of Y}
  \item{x}{Auxiliary Variable of X}
  \item{Vardir}{Sampling Variance of Y}
}}
\usage{
Data_saekernel
}
\description{
Dataset to Simulate Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel

This data is generated by these following steps:
  \enumerate{
    \item Generate explanatory variables \code{Vardir}. \code{Vardir ~ abs(N(0, 0.1))}
    \cr Generate explanatory variables \code{x}. \code{x ~ U(min=0, max=1)}
    \cr Calculate direct estimation \code{y} where \eqn{y_{i}}{yi} = \eqn{sin(2 * \pi * x^3) + 5}
    \item Then combine the direct estimations \code{y}, auxiliary variables \code{x}, and sampling varians \code{Vardir} in a dataframe then named as Data_saekernel
  }
}
\keyword{datasets}
