% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixData-methods.R
\name{saemixData}
\alias{saemixData}
\title{Function to create an SaemixData object}
\usage{
saemixData(
  name.data,
  header,
  sep,
  na,
  name.group,
  name.predictors,
  name.response,
  name.X,
  name.covariates = c(),
  name.genetic.covariates = c(),
  name.mdv = "",
  name.cens = "",
  name.occ = "",
  name.ytype = "",
  units = list(x = "", y = "", covariates = c()),
  verbose = TRUE,
  automatic = TRUE
)
}
\arguments{
\item{name.data}{name of the dataset (can be a character string giving the name of a file on disk or of a dataset in the R session, or the name of a dataset}

\item{header}{whether the dataset/file contains a header. Defaults to TRUE}

\item{sep}{the field separator character. Defaults to any number of blank spaces ("")}

\item{na}{a character vector of the strings which are to be interpreted as NA values. Defaults to c(NA)}

\item{name.group}{name (or number) of the column containing the subject id}

\item{name.predictors}{name (or number) of the column(s) containing the predictors (the algorithm requires at least one predictor x)}

\item{name.response}{name (or number) of the column containing the response variable y modelled by predictor(s) x}

\item{name.X}{name of the column containing the regression variable to be used on the X axis in the plots (defaults to the first predictor)}

\item{name.covariates}{name (or number) of the column(s) containing the covariates, if present (otherwise missing)}

\item{name.genetic.covariates}{name (or number) of the column(s) containing the covariates, if present (otherwise missing)}

\item{name.mdv}{name of the column containing the indicator for missing variable}

\item{name.cens}{name of the column containing the indicator for censoring}

\item{name.occ}{name of the column containing the occasion}

\item{name.ytype}{name of the column containing the index of the response}

\item{units}{list with up to three elements, x, y and optionally covariates, containing the units for the X and Y variables respectively, as well as the units for the different covariates (defaults to empty)}

\item{verbose}{a boolean indicating whether messages should be printed out during the creation of the object}

\item{automatic}{a boolean indicating whether to attempt automatic name recognition when some colum names are missing or wrong (defaults to TRUE)}
}
\value{
An SaemixData object (see \code{\link{saemixData}}).
}
\description{
This function creates an SaemixData object. The only mandatory argument is
the name of the dataset. If the dataset has a header (or named columns), the
program will attempt to detect which column correspond to ID, predictor(s)
and response. Warning messages will be printed during the object creation
and should be read for details.
}
\details{
This function is the user-friendly constructor for the SaemixData object
class. The read.saemixData is a helper function, used to read the dataset,
and is not intended to be called directly.

This function is the user-friendly constructor for the SaemixData object class. The read is a helper function, used to read the dataset, and is not intended to be called directly.
}
\examples{

data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA, 
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

print(saemix.data)

plot(saemix.data)
}
\references{
E Comets, A Lavenu, M Lavielle M (2017). Parameter estimation in nonlinear mixed effect models using saemix,
an R implementation of the SAEM algorithm. Journal of Statistical Software, 80(3):1-41.

E Kuhn, M Lavielle (2005). Maximum likelihood estimation in nonlinear mixed effects models.
Computational Statistics and Data Analysis, 49(4):1020-1038.

E Comets, A Lavenu, M Lavielle (2011). SAEMIX, an R version of the SAEM algorithm. 20th meeting of the
Population Approach Group in Europe, Athens, Greece, Abstr 2173.
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}}, \code{\link{saemixControl}},\code{\link{saemix}}
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}, Audrey Lavenu, Marc Lavielle.
}
