% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eblupfh_ns.R
\name{eblupfh_ns}
\alias{eblupfh_ns}
\title{Synthetic Estimator.}
\usage{
eblupfh_ns(
  formula,
  data,
  vardir,
  method = "REML",
  maxiter = 100,
  precision = 1e-04,
  scale = FALSE,
  print_result = TRUE
)
}
\arguments{
\item{formula}{an object of class formula that contains a description of the model to be fitted. The variables included in the formula must be contained in the data.}

\item{data}{a data frame or a data frame extension (e.g. a tibble).}

\item{vardir}{vector or column names from data that contain variance sampling from the direct estimator for each area.}

\item{method}{Fitting method can be chosen between 'ML' and 'REML'}

\item{maxiter}{maximum number of iterations allowed in the Fisher-scoring algorithm. Default is 100 iterations.}

\item{precision}{convergence tolerance limit for the Fisher-scoring algorithm. Default value is 0.0001.}

\item{scale}{scaling auxiliary variable or not, default value is FALSE.}

\item{print_result}{print coefficient or not, default value is TRUE.}
}
\value{
The function returns a list with the following objects \code{df_res} and \code{fit}:
\code{df_res} a data frame that contains the following columns: \cr
\itemize{
\item \code{y} variable response \cr
\item \code{eblup} estimated results for each area \cr
\item \code{random_effect} random effect for each area \cr
\item \code{vardir} variance sampling from the direct estimator for each area \cr
\item \code{mse} Mean Square Error \cr
\item \code{cluster} cluster information for each area \cr
\item \code{rse} Relative Standart Error (\%) \cr
}

\code{fit} a list containing the following objects: \cr
\itemize{
\item \code{estcoef} a data frame with the estimated model coefficients in the first column (beta),
their asymptotic standard errors in the second column (std.error),
the t-statistics in the third column (tvalue) and the p-values of the significance of each coefficient
in last column (pvalue) \cr
\item \code{model_formula} model formula applied \cr
\item \code{method} type of fitting method applied (\code{ML} or \code{REML}) \cr
\item \code{random_effect_var} estimated random effect variance \cr
\item \code{convergence} logical value that indicates the Fisher-scoring algorithm has converged or not \cr
\item \code{n_iter} number of iterations performed by the Fisher-scoring algorithm. \cr
\item \code{goodness} vector containing several goodness-of-fit measures: loglikehood, AIC, and BIC \cr
}
}
\description{
Synthetic estimator is one of the simple methods to obtain predicted values of mean specific area parameters, which the direct estimates are unknown. Based on estimated of parameter coefficient models using Empirical Best Unbiased Prediction (EBLUP), the synthetic estimator is obtained by calibrating the estimated parameter coefficient to the auxiliary variables.
}
\details{
The model is defined as response ~ auxiliary variables, where the response variable, of numeric type, may contain NA values.
When the response variable contains NA, it will be estimated using a synthetic estimator.
}
\examples{
library(saens)

m1 <- eblupfh_ns(y ~ x1 + x2 + x3, data = mys, vardir = "var")
m1 <- eblupfh_ns(y ~ x1 + x2 + x3, data = mys, vardir = ~var)

}
\references{
\enumerate{
\item Rao, J. N., & Molina, I. (2015). Small area estimation. John Wiley & Sons.
}
}
