% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_tags.R
\name{set_tags}
\alias{set_tags}
\title{Change tags of a safeframe object}
\usage{
set_tags(x, ...)
}
\arguments{
\item{x}{a \code{data.frame} or a \code{tibble}, equivalent to parameter \code{.data} in
\code{\link[=make_safeframe]{make_safeframe()}}}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A series of tags provided as
\code{tag_name = "column_name"}}
}
\value{
The function returns a \code{safeframe} object.
}
\description{
This function changes the \code{tags} of a \code{safeframe} object, using the same
syntax as the constructor \code{\link[=make_safeframe]{make_safeframe()}}.
}
\examples{

## create a safeframe
x <- make_safeframe(cars, mph = "speed")
tags(x)

## add new tags and fix an existing one
x <- set_tags(x, distance = "dist")
tags(x)

## remove tags by setting them to NULL
old_tags <- tags(x)
x <- set_tags(x, mph = NULL, distance = NULL)
tags(x)

## setting tags providing a list (used to restore old tags here)
x <- set_tags(x, !!!old_tags)
tags(x)
}
\seealso{
\code{\link[=make_safeframe]{make_safeframe()}} to create a \code{safeframe} object
}
