% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags_df.R
\name{tags_df}
\alias{tags_df}
\title{Extract a data.frame of all tagged variables}
\usage{
tags_df(x)
}
\arguments{
\item{x}{a \code{safeframe} object}
}
\value{
A \code{data.frame} of with variables renamed according to their tags
}
\description{
This function returns a \code{data.frame}, where tagged variables (as stored in
the \code{safeframe} object) are renamed. Note that the output is no longer a
\code{safeframe}, but a regular \code{data.frame}. untagged variables are unaffected.
}
\examples{

x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)

## get a data.frame with variables renamed based on tags
tags_df(x)
}
