% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{designSafeLogrank}
\alias{designSafeLogrank}
\title{Designs a Safe Logrank Test Experiment}
\usage{
designSafeLogrank(
  hrMin = NULL,
  beta = NULL,
  nEvents = NULL,
  h0 = 1,
  alternative = c("twoSided", "greater", "less"),
  alpha = 0.05,
  ratio = 1,
  exact = TRUE,
  tol = 1e-05,
  m0 = 50000L,
  m1 = 50000L,
  nSim = 1000L,
  nBoot = 10000L,
  parameter = NULL,
  groupSizePerTimeFunction = returnOne,
  pb = TRUE,
  ...
)
}
\arguments{
\item{hrMin}{numeric that defines the minimal relevant hazard ratio, the smallest hazard ratio that we want to
detect.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{nEvents}{numeric > 0, targetted number of events.}

\item{h0}{numeric > 0, represents the null hypothesis, default h0=1.}

\item{alternative}{a character string specifying the alternative hypothesis, which must be one of
"twoSided" (default),"greater" or "less". The alternative is pitted against the null hypothesis of equality
of the survival distributions. More specifically, let lambda1 be the hazard rate of group 1 (i.e., placebo), and
lambda2 the hazard ratio of group 2 (i.e., treatment), then the null hypothesis states that the hazard ratio
theta = lambda2/lambda1 = 1. If alternative = "less", the null hypothesis is compared to theta < 1, thus,
lambda2 < lambda1, that is, the hazard of group 2 (i.e., treatment) is less than that of group 1 (i.e., placebo),
hence, the treatment is beneficial. If alternative = "greater", then the null hypothesis is compared to theta > 1,
thus, lambda2 > lambda1, hence, harm.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 (Treatment) over condition 1 (Placebo),
thus, m1/m0. Note that m1 and m0 are not used to specify ratio. Ratio is only used when \code{zApprox=TRUE}, which
ignores m1 and m0.}

\item{exact}{a logical indicating whether the design should be based on the exact safe logrank test based on the
hypergeometric likelihood. Default is \code{TRUE}, if \code{FALSE} then the design is based on a  safe z-test.}

\item{tol}{a number that defines the stepsizes between the lowParam and highParam.}

\item{m0}{Number of subjects in the control group 0/1 at the beginning of the trial, i.e., nPlan[1].}

\item{m1}{Number of subjects in the treatment group 1/2 at the beginning of the trial, i.e., nPlan[2].}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of events for the exact
safe logrank test under continuous monitoring}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of the approximation of
power or nEvents for the exact safe logrank test under continuous monitoring}

\item{parameter}{Numeric > 0, represents the safe tests defining thetaS. Default NULL so it's decided by the
algorithm, typically, this equals hrMin, which corresponds to the GROW choice.}

\item{groupSizePerTimeFunction}{A function without parameters and integer output. This function provides the number
of events at each time step. For instance, if \code{rpois(1, 7)} leads to a random number of events at each time
step.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a safeDesign object that includes:

\describe{
  \item{nEvents}{the anticipated number of events, either (1) specified by the user, or
  (2) computed based on beta and thetaMin.}
  \item{parameter}{the parameter that defines the safe test. Here log(thetaS).}
  \item{esMin}{the minimally clinically relevant hazard ratio specified by the user.}
  \item{alpha}{the tolerable type I error provided by the user.}
  \item{beta}{the tolerable type II error provided by the user.}
  \item{alternative}{any of "twoSided", "greater", "less" provided by the user.}
  \item{testType}{"logrank".}
  \item{ratio}{default is 1. It defines the ratio between the planned randomisation of
  condition 2 over condition 1.}
  \item{pilot}{\code{FALSE} to indicate that the design is not a pilot study.}
  \item{call}{the expression with which this function is called.}
}
}
\description{
A designed experiment requires (1) an anticipated number of events nEvents, or even better nPlan, the number of
participants to be recruited in the study, and (2) the parameter of the safe test, i.e., thetaS. Provided with a
clinically relevant minimal hazard ratio hrMin, this function outputs thetaS = hrMin as the safe test defining
parameter in accordance to the GROW criterion. If a tolerable type II error beta is provided then nEvents can be
sampled. The sampled nEvents is then the smallest nEvents for which hrMin is found with power of at least 1 - beta
under optional stopping. If exact equal \code{FALSE}, then the computations exploit the local asymptotic normal
approximation to sampling distribution of the logrank test derived by Schoenfeld (1981).
}
\examples{
designSafeLogrank(hrMin=0.7)
designSafeLogrank(hrMin=0.7, zApprox=TRUE)
designSafeLogrank(hrMin=0.7, beta=0.3, nSim=10)
designSafeLogrank(hrMin=0.7, nEvents=190, nSim=10)
}
\references{
Schoenfeld, D. (1981). The asymptotic properties of nonparametric tests
for comparing survival distributions. Biometrika, 68(1), 316-319.
}
