% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-d.r, R/dual-value.r, R/dual-varnames.r
\name{d}
\alias{d}
\alias{d.dual}
\alias{d.numeric}
\alias{value}
\alias{value.dual}
\alias{value.numeric}
\alias{varnames}
\alias{varnames.dual}
\alias{varnames.numeric}
\title{get list of derivatives}
\usage{
d(x, varnames)

value(x)

\method{value}{dual}(x)

\method{value}{numeric}(x)

varnames(x)

\method{varnames}{dual}(x)

\method{varnames}{numeric}(x)
}
\arguments{
\item{x}{a dual (or numeric) oject}

\item{varnames}{(optional) a vector or varnames to take derivatives along}
}
\value{
A named list of derivatives.
}
\description{
Get value, differential of a dual object, and the names of associated variables.
}
\details{
If `varnames` is provided to the function `d`, a list of derivatives along the given variables will be sent back. 
In general, it sends back the derivatives along all associated variables.

The `varnames` function sends back the names of all variables
for which a derivative is defined.
}
\examples{
x <- dual(c(3,2))
varnames(x^2)
x**2
value(x**2)
d(x**2)
d(x**2, "x1")
# you can use these methods with a numerical constant
value(1)
varnames(1)
d(1, "x1")

}
