% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-matrix-det-solve.r
\name{inversion}
\alias{inversion}
\alias{det.dual}
\alias{det}
\alias{determinant}
\alias{solve}
\alias{det,dual-method}
\alias{determinant.dual}
\alias{solve,dual,dual-method}
\alias{solve,dual,missing-method}
\alias{solve,numericOrArray,dual-method}
\alias{solve,dual,numericOrArray-method}
\title{Determinant and matrix inversion for dual matrices}
\usage{
det.dual(x, ...)

\S4method{det}{dual}(x, ...)

\method{determinant}{dual}(x, logarithm = TRUE, ...)

\S4method{solve}{dual,dual}(a, b, ...)

\S4method{solve}{dual,missing}(a, b, ...)

\S4method{solve}{numericOrArray,dual}(a, b, ...)

\S4method{solve}{dual,numericOrArray}(a, b, ...)
}
\arguments{
\item{x}{a dual matrix}

\item{...}{extra parameters (ignored)}

\item{logarithm}{if 'TRUE', get logarithm of modulus of determinant}

\item{a, b}{dual or numerical arguments for `solve`}
}
\value{
'det' returns a dual scalar, 'determinant' a list with components 'modulus' (which is a dual object)
and 'sign', and 'solve' returns a dual object (vector or matrix).
}
\description{
Methods extending to dual matrices the corresponding methods for numeric matrices.
}
\examples{
x <- dual( matrix(c(1,2,1,3), 2, 2) )
det(x)
d(det(x), "x1.1")
solve(x)
d(solve(x), "x1.1")

}
