% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.sample.R
\name{cluster.sample}
\alias{cluster.sample}
\title{Cluster sample for non-grouped data.}
\usage{
cluster.sample(data, n, replace = FALSE)
}
\arguments{
\item{data}{Matrix or data.frame containing the population data in first column and the cluster it belongs to in the last column.}

\item{n}{Number of clusters of the returning sample.}

\item{replace}{Whether the sample to be taken can have repeated clusters or not.}
}
\value{
Data frame of a clustered sample
}
\description{
Retrieves a sample of clusters for data which interest variable values
are not grouped by cluster.\cr
}
\details{
#' If your data is grouped by cluster use \code{\link{srs.sample}} function to retrieve
your sample. Remember grouped by cluster data must have interest variable data in the first column,
cluster size in the second and the cluster name in the last column. Interest
values of grouped data must reflect the total value of each cluster.
}
\examples{
data<-cbind(rnorm(500, 50, 20), rep(c(1:50),10))
sample<-cluster.sample(data, 10);sample

}
