% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{castillo2024.rgmomentum.e1}
\alias{castillo2024.rgmomentum.e1}
\title{Data from Experiment 1 in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplrData}}
\format{
An object of class \code{data.frame} with 5836 rows and 29 columns.
}
\source{
\url{https://osf.io/dw8ez/}
}
\usage{
castillo2024.rgmomentum.e1
}
\description{
Participants produced a random sequence of heights of either men or women in the United Kingdom. In one sequence, they sampled heights as distributed according to a uniform distribution (Uniform condition); in the other sequence, heights were distributed following their actual distribution (which is roughly Gaussian).
These data are licensed under \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0}, reproduced from materials in \href{https://osf.io/dw8ez/}{OSF}.
\describe{
\item{id}{participant id}
\item{part_Gender}{participant's gender (self-reported)}
\item{part_Height}{participant's own height (self-reported)}
\item{part_Home}{participant's home country (self-reported)}
\item{RQ_Rep}{percentage of correct responses in Randomness Questionnaire, for coin toss pairs where one sequence had too many repetitions}
\item{RQ_Alt}{percentage of correct responses in Randomness Questionnaire, for coin toss pairs where one sequence had too many alternations}
\item{RQ_GFM}{percentage of correct responses in Randomness Questionnaire, Gambling Fallacies Measure section}
\item{minHeight}{height participant reports to be the shortest adult in the UK (from target gender)}
\item{maxHeight}{height participant reports to be the tallest adult in the UK (from target gender)}
\item{condition}{whether the participant did the uniform condition first (UN) or not (NU)}
\item{target_gender}{gender they had to generate heights from, either male (M) or female (F)}
\item{index}{position of the item in the sequence, 0 indexed}
\item{block}{whether the item belongs to the first sequence the participant uttered (A) or the second (B)}
\item{target_dist}{whether the instructions asked for heights as distributed in the population (N) or uniformly distributed (U)}
\item{label}{what the participant uttered}
\item{unit}{height unit, either centimetres (cm) or feet and inches (f_in).}
\item{value}{value in cms of the height uttered.}
\item{value_in_units}{value of the height uttered depending on the value of \code{unit} (either in inches or in centimetres). Used to calculate adjacencies, distances, etc.}
\item{starts}{timestamp of when the utterance starts, in seconds.}
\item{delays}{temporal difference with the start of the previous item (i.e. \code{starts[index] - starts[index - 1]})}
\item{R}{whether the item is a repetition of the last}
\item{A}{whether the item is adjacent to the last (after removing repetitions)}
\item{TP_full}{whether the item is a turning point, considering all items (after removing repetitions)}
\item{D}{the Euclidean distance to the previous item (after removing repetitions)}
\item{S}{a measure of how likely the item is in a uniform or gaussian distribution (see text)}
\item{expected_*}{the expectation for measure \code{*} derived from reshuffling the participant's sequence 10000 times}
}
}
\references{
\insertRef{castillo2024ExplainingFlawsHuman}{samplrData}
}
\keyword{datasets}
