% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen.R
\name{eigen2}
\alias{eigen2}
\title{Spectral Decomposition}
\usage{
eigen2(a, symmetric, vectors = TRUE)
}
\arguments{
\item{a}{Square numeric matrix.}

\item{symmetric}{Logical scalar indicating whether 'a' is symmetric. By
default symmetry is checked up to machine precision, which may take a long
time for symmetric matrices.}

\item{vectors}{Logical scalar indicating whether eigenvectors should be
computed and returned.}
}
\value{
Solves the eigenproblem and returns a list with eigenvalues in
the \code{"values"} slot and, if requested, eigenvectors in the slot
\code{"vectors"}.
}
\description{
Solvers for eigenproblems around the matrix \eqn{A}. Compute eigenvalues
\eqn{\lambda}{l} and eigenvectors \eqn{v}{v} of \eqn{A}{A}, such that
\eqn{Av = \lambda v}{Av = lv}.
}
\examples{
set.seed(42)
# Compute eigenvalues and eigenvectors for a square matrix
A <- matrix(rnorm(9), nrow = 3, ncol = 3)
ev <- eigen2(A, symmetric = FALSE)

# Compute eigenvalues and eigenvectors for a symmetric matrix
A <- crossprod(matrix(rnorm(9), nrow = 3, ncol = 3))
ev <- eigen2(A, symmetric = TRUE)
# Check reconstruction
norm(A \%*\% ev$vectors - ev$vectors \%*\% diag(ev$values))

}
