% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_cols_bounded}
\alias{sc_cols_bounded}
\title{Checks that all elements from the specified columns are in a certain range}
\usage{
sc_cols_bounded(object, cols, rule = "(-Inf, Inf)", ...)
}
\arguments{
\item{object}{table with a columns specified by \code{cols}}

\item{cols}{vector of characters of columns that are checked against
the specified range}

\item{rule}{check as two numbers separated by a comma, enclosed by square
brackets (endpoint included) or parentheses (endpoint excluded).
For example, “[0, 3)” results in all(x >= 0 & x < 3).
The lower and upper bound may be omitted which is the equivalent
of a negative or positive infinite bound, respectively.
By definition [0,] contains Inf, while [0,)
does not. The same holds for the left (lower) boundary and -Inf.
This explanation was copied from \code{checkmate::qtest}. That function
is also the backbone of the this function.}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}
}
\value{
list of logical vectors where TRUE indicates where the check failed.
  Every list entry represents one of the columns specified in cols.
  This might be helpful if one wants to apply a counter-measure
}
\description{
Checks that all elements from the specified columns are in a certain range
}
\examples{
dummy_call <- function(x) {
  sc_cols_bounded(object = iris, cols = c("Sepal.Length", "Petal.Length"),
    rule = "[1, 7.9)")
}
dummy_call(x = d)
get_sanity_checks()
}
