% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc-test.R
\name{cmc_psat}
\alias{cmc_psat}
\title{Polygons Spatial Association Test - Global Envelope}
\usage{
cmc_psat(
  p1,
  p2,
  id_col = NULL,
  n_sim = 499L,
  alpha = 0.01,
  var_st = TRUE,
  ts = "SMAD",
  distances = NULL,
  hausdorff = TRUE,
  method = "rnd_poly"
)
}
\arguments{
\item{p1}{a \code{sf} object containing one column specifying the objects
id.}

\item{p2}{a \code{sf} object containing one column specifying the objects
id.}

\item{id_col}{a \code{character} or \code{integer} indicating the column of
\code{p1} storing the unique identifier for the polygons/sample units.}

\item{n_sim}{an \code{integer} corresponding to the number of Monte Carlo
simulations for the test}

\item{alpha}{a \code{numeric} indicating the confidence level.}

\item{var_st}{use the variance stabilizing funciton?}

\item{ts}{a \code{character} associated to a test statistic. Inputs acepted:
\code{c('IM', 'MAD', 'SIM', 'SMAD', 'IMDQ', 'MADDQ')}.}

\item{distances}{a \code{numeric vector} indicating the distances to
evaluate \eqn{H(d)}. If \code{NULL} then the range considered goes from 5\%
to 20\% of the max distance that can be observed inside the study region.}

\item{hausdorff}{a \code{logical} scalar indicating whether the Hausdorff
distance should be used (default is TRUE).}

\item{method}{(default = "rng_poly") a \code{character} indicating the
method used to deal with broken polygons in the Toroidal Shift. Valid
options are \code{c("min", "max", "mean", "rnd_poly", "rnd_dist",
  "min_norm", "max_norm", "hybrid", "hyb_center", "hybrid_nc", "old_min")}.}
}
\value{
a \code{list} with values: \describe{
\item{p_value}{a \code{numeric} scalar giving the p-value of the test}
\item{mc_sample}{a \code{numeric} vector giving the test statistic for each of the Monte Carlo simulations}
\item{mc_funct}{a \code{matrix} where each line correspond to the function (\eqn{K} or \eqn{L}) estimated
for the Monte Carlo simulations}
\item{distances}{\code{numeric vector} containing the distances where mc_func were evaluated.}
\item{alpha}{a \code{numeric} scalar giving the significance level}
\item{rejects}{a \code{logical} scalar, TRUE if the null hypothesis is reject}
}
}
\description{
A Monte Carlo test to verify if two sets of polygons are
associated based in a global envelope of the functions
\eqn{K_{12}(d)} and \eqn{L_{12}(d)} using different test statistics.
}
\examples{
library(sapo)
library(sf)
set.seed(2024)

 ## loading toy data
poly1 <- system.file("extdata", "poly1.rds", package = "sapo") |>
  readRDS()
poly2 <- system.file("extdata", "poly2.rds", package = "sapo") |>
  readRDS()

my_ht <- cmc_psat(poly1, poly2, n_sim = 199)
my_ht$p_value

}
