% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeCritCutLength.R
\name{computeCritCutLength}
\alias{computeCritCutLength}
\alias{computeCritCutLength.snowprofileSet}
\alias{computeCritCutLength.snowprofile}
\alias{computeCritCutLength.snowprofileLayers}
\title{Compute critical crack length}
\usage{
computeCritCutLength(x)

\method{computeCritCutLength}{snowprofileSet}(x)

\method{computeCritCutLength}{snowprofile}(x)

\method{computeCritCutLength}{snowprofileLayers}(x)
}
\arguments{
\item{x}{\link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet}, \link[sarp.snowprofile:snowprofile]{sarp.snowprofile::snowprofile}, or \link[sarp.snowprofile:snowprofileLayers]{sarp.snowprofile::snowprofileLayers} object}
}
\value{
Input object is returned with \verb{$crit_cut_length} (and potentially \verb{$slab_rho}) appended to the layers object.
}
\description{
This function implements Bettina Richter's (2019) parametrization for the critical crack length for flat simulations based on
density, grain size, and shear strength. The parametrization also needs the mean density of the slab, which can be computed
automatically if a snowprofile object is provided. In case the functions gets a snowprofileLayers object it expects \code{slab_rho} being precomputed.
This acts as a safety mechanism to ensure that \code{slab_rho} is computed over one profile and not over a stacked layers data.frame containing multiple
profiles. Note that the critical crack length can be computed alongside the layer probabilities for instability \code{p_unstable} in \link{computePunstable}.
}
\section{Methods (by class)}{
\itemize{
\item \code{computeCritCutLength(snowprofileSet)}: for \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet}s

\item \code{computeCritCutLength(snowprofile)}: for \link[sarp.snowprofile:snowprofile]{sarp.snowprofile::snowprofile}s

\item \code{computeCritCutLength(snowprofileLayers)}: for \link[sarp.snowprofile:snowprofileLayers]{sarp.snowprofile::snowprofileLayers}

}}
\references{
Richter, B., Schweizer, J., Rotach, M. W., & Van Herwijnen, A. (2019).
Validating modeled critical crack length for crack propagation in the snow cover model SNOWPACK.
The Cryosphere, 13(12), 3353–3366. https://doi.org/10.5194/tc-13-3353-2019
}
\seealso{
\link{computePunstable}
}
\author{
fherla based on the python function by smayer and brichter
}
