% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsbgamma.r
\name{dsbgamma}
\alias{dsbgamma}
\title{Size biased gamma probability density}
\usage{
dsbgamma(x, lmean, lrate, log = FALSE, xlog = FALSE)
}
\arguments{
\item{x}{A vector of positive numbers.}

\item{lmean}{The mean of the distribution on the log scale.}

\item{lrate}{The log rate parameter of the underlying gamma distribution.}

\item{log}{A logical indicating whether to return log densities.}

\item{xlog}{A logical indicating whether to return densities for log
transformed data.}
}
\value{
A vector of probability densities.
}
\description{
Calculates size biased gamma probability density - the underlying
gamma probability density when the likelihood of recording an
observation is proportional to its value.
}
\examples{
  data(BCI_speed_data)
  agoutiData <- subset(BCI_speed_data, species=="agouti")
  dsbgamma(agoutiData$speed, 0, 0.1)
}
