% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{crossSpeciesCellTypeGOCorr}
\alias{crossSpeciesCellTypeGOCorr}
\title{calculate cross-species correlation between cell types represented by scaled GO}
\usage{
crossSpeciesCellTypeGOCorr(
  species_1,
  species_2,
  cell_type_go_sp1,
  cell_type_go_sp2,
  corr_method = "pearson"
)
}
\arguments{
\item{species_1}{name of species one}

\item{species_2}{name of species two}

\item{cell_type_go_sp1}{cell type GO table of species one calculated via getCellTypeGO}

\item{cell_type_go_sp2}{cell type GO table of species two calculated via getCellTypeGO}

\item{corr_method}{correlation method, choose among "pearson", "kendall", "spearman", default 'pearson'}
}
\value{
correlation between cell types
}
\description{
calculate cross-species correlation between cell types represented by scaled GO
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
data(mmu_tbl)
data(mmu_subset)
data(dme_tbl)
data(dme_subset)
mmu_go_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")
dme_go_obj = makeGOSeurat(ensembl_to_GO = dme_tbl,
 seurat_obj = dme_subset,
 feature_type = "external_gene_name")

mmu_cell_type_go = getCellTypeGO(go_seurat_obj = mmu_go_obj, cell_type_co = "cell_type_annotation")
dme_cell_type_go = getCellTypeGO(go_seurat_obj = dme_go_obj, cell_type_co = "annotation")

crossSpeciesCellTypeGOCorr(species_1 = 'mmusculus',
 species_2 = 'dmelanogaster',
 cell_type_go_sp1 = mmu_cell_type_go,
 cell_type_go_sp2 = dme_cell_type_go)
}
}
