% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot_tree}
\alias{plot_tree}
\title{Plot model tree}
\usage{
plot_tree(model, box.size = 8, edge.text.size = 4)
}
\arguments{
\item{model}{A scGate model to be visualized}

\item{box.size}{Box size}

\item{edge.text.size}{Edge text size}
}
\value{
A plot of the model as a decision tree. At each level, green boxes
    indicate the 'positive' (accepted) cell types, red boxed indicate the
    'negative' cell types (filtered out). The final Pure population is the
    bottom right subset in the tree.
}
\description{
View scGate model as a decision tree (require ggparty package)
}
\examples{
library(ggparty)
models <- get_scGateDB()
plot_tree(models$human$generic$Tcell)
}
