% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.conductance_states}
\alias{bursts.conductance_states}
\title{Return a list of all the (sub)conductance states.}
\usage{
bursts.conductance_states(bursts)
}
\arguments{
\item{bursts}{The list of all bursts}
}
\value{
a list of all the (sub)conductance states.
}
\description{
Return a list of all the (sub)conductance states.
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

bursts.conductance_states(bursts)

}
